<!– MapServer Template –>
<!DOCTYPE html>
<html>
<head>
 <meta charset="utf-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <link rel="stylesheet" href="css/leaflet.css" />
    <!-- TWITTER BOOTSTRAP CSS -->
    <link href="css/bootstrap.css" rel="stylesheet" type="text/css"/>

  <style>
   #map { width: 92%; height: 800px; border: 1px solid #ffff00; cursor: pointer; }
   ul>li { font-size: 10px; }

.info {
 padding: 4px 6px;
 font: 14px/16px Arial, Helvetica, sans-serif;
 background: #ffffff;
# background: rgba(255,255,250,0.8);
 box-shadow: 0 0 15px rgba(0,0,0,0.2);
 border-radius: 5px;
}
.info h4 {
 margin: 0 0 5px;
 color: #777;
}


.legend {
 text-align:left;
 line-height: 16px;
 color: #555;
}
.legend i {
 width: 18px;
 height: 18px;
 float: left;
 margin-right: 8px;
 opacity: 0.7;
}

</style>
</head>


<body>
<?
require("conecta.php");

$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
$horas= $today['hours'];
$minutos= $today['minutes'];
$xhos=$_SERVER['REMOTE_ADDR'];
$xdatakl=sprintf("%02d/%02d/%04d %02d:%02d",$mday,$month,$year,$horas,$minutos);

$volta=(int)$volta;

 /*
  1 = acucar
  2 = milho
  3 = soja
 */

 $geoson='{"type":"FeatureCollection","features":['; 

// echo "<br>xtpma=$xtpma<br>xprod=$xprod";

  $result=pg_Exec($conn,"select nome from municipio_sp");
 
  $num=pg_numrows($result);
  $minvalor=999999;$maxvalor=0;
 
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome,valor_teste from municipio_sp where nome='$r[0]'");
   $rh=pg_fetch_row($rf,0);
   $rh[2]=trim((int)$rh[2]);
   $rh[1]=trim($rh[1]);
   if(strlen($rh[1])==0) continue;
   if($rh[2]>$maxvalor) $maxvalor=$rh[2];
   if($rh[2]<$minvalor) $minvalor=$rh[2];
  
   $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$rh[2],$rh[0]);
  } 
  $geoson.="]}";

echo "<br>$minvalor - $maxvalor";

echo "
 <div id=map></div>\n";

echo " <script src=js/leaflet.js></script>\n";
 
//echo " <script src=https://unpkg.com/leaflet@1.0.3/dist/leaflet.js></script>\n";
echo "
 <script src=js/jquery-2.1.1.min.js></script>\n
 <script src=js/bundle.js></script>\n

 <script>\n
   var statesData=$geoson;\n
";
?>
var map = L.map('map').setView([-22.06019, -48.70239], 8);

<!-- var results=new L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {}).addTo(map); -->

<!--var results = L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}.png', { -->
<!--			maxZoom: 18,  -->
<!--			attribution: 'Map data © <a href="http://openstreetmap.org">OpenStreetMap</a> contributors', -->
<!-- 		}).addTo(map); -->

<?
echo "var host = 'http://192.168.4.12/cgi/rocha/mapserv.fcgi?'";
//echo "var host = 'http://179.234.170.113:6080/sergio/esalqlog/mapserv.fcgi?'";
echo "
\n
   var mapfile = 'map=inter.map';
   var wms_server = host + mapfile;

   var municipios = L.tileLayer.wms(wms_server, {
      layers: 'municipios',
      format: 'image/png',
      srs:'EPSG:4291',
      opacity: 10,
      transparency : 10,
      pointerCursor: true,
      status:true
   }).addTo(map);\n";
   
//echo "
//   function onEachFeature(feature,layer) {
//    if (feature.properties && feature.properties.name) {
//     var popupContent='Cidade '+feature.properties.name+'<br>Density '+feature.properties.density
//    }
//    layer.bindPopup(popupContent);
//   } 
//\n";

 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.density),
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'white',        // contorno dos estados
   dashArray: '1',
   fillOpacity: 0.85
  };
  
 }\n";

  $distancia=($maxvalor - $minvalor) / 10;
  

  $passo1 = $minvalor + $distancia; 
  $passo2 = $passo1 + $distancia;
  $passo3 = $passo2 + $distancia;
  $passo4 = $passo3 + $distancia;
  $passo5 = $passo4 + $distancia;
  $passo6 = $passo5 + $distancia;
  $passo7 = $passo6 + $distancia;
  $passo8 = $passo7 + $distancia;
  $passo9 = $passo8 + $distancia;
  $passo10= $passo9 + $distancia;

 echo "
 function getColor(d) {
   return d>  $passo9  ? '#00441b':
          d > $passo8  ? '#006d2c' :
          d > $passo7  ? '#238b45' :
          d > $passo6  ? '#41ab5d' :
          d > $passo5  ? '#74c476' :
          d > $passo4  ? '#a1d99b' :
          d > $passo3  ? '#c7e9c0' :
          d > $passo2  ? '#e5f5e0' :
          d > $passo1  ? '#f7fcf5' :
          '#ffed6f';
 }\n";


echo "
function highlightFeature(e) {
 var layer = e.target;
    
 layer.setStyle({
 weight: 2,
 color: '#ff4500',
 dashArray: '1',
 fillOpacity: 0.7
 });
                                           
 if (!L.Browser.ie && !L.Browser.opera && !L.Browser.edge) {
  layer.bringToFront();
 }
 info.update(layer.feature.properties); 
}
                                                            

function resetHighlight(e) {
 geojson.resetStyle(e.target);
}


function zoomToFeature(e) {
 map.fitBounds(e.target.getBounds());
}
\n";

 echo "
 function onEachFeature(feature, layer) {
  layer.on({
  mouseover: highlightFeature,
  mouseout: resetHighlight
  });
  if (feature.properties && feature.properties.name) {
   var popupContent='Cidade '+feature.properties.name+'<br>Density '+feature.properties.density
  }
  layer.bindPopup(popupContent);
 }  
  
\n";

 echo "                                
 geojson = L.geoJson(statesData, {
 style: style,
 onEachFeature: onEachFeature
}).addTo(map);
";


 echo "L.geoJson(statesData,{style:style,onEachFeature:onEachFeature})
       .addTo(map);
 \n";


echo "var legend = L.control({position: 'bottomright'});\n";

 echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),
  grades = [0, $passo1,$passo2,$passo3,$passo4,$passo5,$passo6,$passo7,$passo8,$passo9 ],
  labels = ['<strong>Populacao </strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   to = grades[i + 1];
                
   labels.push(
//   '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));
  '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));

  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";


echo "
var info = L.control();

info.onAdd = function (map) {
 this._div = L.DomUtil.create('div', 'info'); // cria  a div class 'info'
 this.update();
 return this._div;
};
";
            
 echo "
 info.update = function (props) {
 this._div.innerHTML = '<h5>INDICADOR POPULACAO</h5>' +  (props ?
 '<b>' + props.name + '</b><br />' + props.density : 'Escolha uma cidade');
 };info.addTo(map);
 ";



echo "</script>";




echo "<div id=dados style='position:absolute; left:93%;top:200px;'>";
echo "<a href=fretes.php><button type=button class='btn btn-small'>Nova analise</button></a>"


?>
