<!– MapServer Template –>
<!DOCTYPE html>
<html>
<head>
 <meta charset="utf-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <link rel="stylesheet" href="js/leaflet.css" />
    <!-- TWITTER BOOTSTRAP CSS -->
    <link href="css/bootstrap.css" rel="stylesheet" type="text/css"/>

  <style>
   #map { width: 92%; height: 800px; border: 1px solid #ffff00; cursor: pointer; padding:1px;align-items:center;margin:auto; }
   ul>li { font-size: 10px; }

.info {
 padding: 4px 6px;
 font: 14px/16px Arial, Helvetica, sans-serif;
 background: #ffffff;
# background: rgba(255,255,250,0.8);
 box-shadow: 0 0 15px rgba(0,0,0,0.2);
 border-radius: 5px;
}
.info h4 {
 margin: 0 0 5px;
 color: #777;
}


.legend {
 text-align:left;
 line-height: 16px;
 color: #555;
}
.legend i {
 width: 18px;
 height: 18px;
 float: left;
 margin-right: 8px;
 opacity: 0.7;
}

</style>
</head>


<body>
<?
require("conecta.php");

$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
$horas= $today['hours'];
$minutos= $today['minutes'];
$xhos=$_SERVER['REMOTE_ADDR'];
$xdatakl=sprintf("%02d/%02d/%04d %02d:%02d",$mday,$month,$year,$horas,$minutos);

 $geoson='{"type":"FeatureCollection","features":['; 

// echo "<br>xtpma=$xtpma<br>xprod=$xprod";

  $result=pg_Exec($conn,"select gid from mesoregioes limit 1");
 
  $num=pg_numrows($result);
  $minvalor=999999;$maxvalor=0;
 
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
//   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome||' '||uf,valor_teste from municipios where gid='$r[0]'");
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome_meso,valor_teste from mesoregioes where gid='$r[0]'");
   $rh=pg_fetch_row($rf,0);
   $rh[2]=trim((int)$rh[2]);
   $rh[1]=trim($rh[1]);
   if(strlen($rh[1])==0) continue;
   if($rh[2]>$maxvalor) $maxvalor=$rh[2];
   if($rh[2]<$minvalor) $minvalor=$rh[2];
  
   $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$rh[2],$rh[0]);
  } 
  $geoson.="]}";


  $distancia=($maxvalor) / 7;
  

  $passo1 = round($minvalor,1); 
  $passo2 = round($passo1 + $distancia,1);
  $passo3 = round($passo2 + $distancia,1);
  $passo4 = round($passo3 + $distancia,1);
  $passo5 = round($passo4 + $distancia,1);
  $passo6 = round($passo5 + $distancia,1);
  $passo7 = round($passo6 + $distancia,1);
//  $passo8 = round($passo7 + $distancia,1);
//  $passo9 = round($passo8 + $distancia,1);
//  $passo10= round($passo9 + $distancia,1);




// layer shape benito
 $geobenito='{"type":"FeatureCollection","features":['; 
/*
  $result=pg_Exec($conn,"select gid from pedologico_sp_rossi_2017");
  $num=pg_numrows($result);
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),unidade_de 
                      from pedologico_sp_rossi_2017 where gid='$r[0]'");
//   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),sigla_unid||' '||nome_unida
//                      from geologia_sp where gid='$r[0]'");

   $rh=pg_fetch_row($rf,0);
   $rh[1]=trim($rh[1]);
   $rh[0]=trim($rh[0]);
   if(strlen($rh[1])==0 or strlen($rh[0])==0) continue;
   $geobenito.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],0,$rh[0]);
  } 
*/  
  $geobenito.="]}";



//echo "<br>$minvalor - $maxvalor";

echo "
 <div id=map></div>\n";

echo " <script src=js/leaflet.js></script>\n";
 
//echo " <script src=https://unpkg.com/leaflet@1.0.3/dist/leaflet.js></script>\n";
echo "
 <script src=js/jquery-2.1.1.min.js></script>\n
 <script src=js/bundle.js></script>\n
";

echo "
 <script>\n";
/*
echo " 
   var statesData=$geoson;\n
   var benito=$geobenito;\n
";
*/
//echo "
// var results=new L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {}).addTo(map);\n";

/*
echo "
// var results = L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}.png', {
//			maxZoom: 18,  
//			attribution: 'Map data © <a href='http://openstreetmap.org'>OpenStreetMap</a> contributors, 
// 		}).addTo(map);
\n";
*/

echo "var map = L.map('map').setView([-22.931677, -48.521582], 7);\n";


echo "var host = 'http://127.0.0.1/cgi/benito/mapserv.fcgi?'";

echo "
   var mapfile = 'map=/var/www/html/cgi/benito/inter1.map&';
   var wms_server = host + mapfile;\n";


echo "
   var geologia =  L.tileLayer.wms(wms_server, {
      layers: 'geologia',
      format: 'image/png',
      srs:'EPSG:4291',
      transparent : true,
      status:true
   }).addTo(map);\n";



echo "
   var saopaulo = L.tileLayer.wms(wms_server, {
      layers: 'saopaulo',
      format: 'image/png',
      srs:'EPSG:4291',
      transparent : true,
      pointerCursor: true,
      status:true
   }).addTo(map);\n";


echo "   
   var pedologico =  L.tileLayer.wms(wms_server, {
      layers: 'pedologico',
      format: 'image/png',
      srs:'EPSG:4291',
      transparent : true,
      status:true
   }).addTo(map);\n";



//echo "var results=L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {}).addTo(map);\n";


echo "
  var baseMaps={};
  var overlayMaps={'SP':saopaulo,
                   'Pedologico':pedologico,
                   'Geo':geologia            
                  };\n";


echo "
L.control.layers(baseMaps,overlayMaps).addTo(map);\n";


echo "  
 function Identify (e) {
  var BBOX = map.getBounds().toBBoxString();
  var WIDTH = map.getSize().x;
  var HEIGHT = map.getSize().y;
  var X = map.layerPointToContainerPoint(e.layerPoint).x;
  var Y = map.layerPointToContainerPoint(e.layerPoint).y;
  var URL = wms_server + 'SERVICE=WMS&VERSION=1.1.1&REQUEST=GetFeatureInfo&LAYERS=municipios&QUERY_LAYERS=municipios&BBOX='+BBOX+'&FEATURE_COUNT=1&HEIGHT='+HEIGHT+'&WIDTH='+WIDTH+'&INFO_FORMAT=text%2Fhtml&SRS=EPSG%3A4291&X='+X+'&Y='+Y;

  $.ajax({
   url:URL,
   datatype: 'html',
   type: 'GET',
   success: function(data) {
    var popup = new L.popup({
    maxWith: 300
   });
    popup.setContent(data);
    popup.setLatLng(e.latlng);
    map.openPopup(popup);
   }
  });
 }\n";
 
echo "
map.addEventListener('click', Identify);\n";
                                                                                                                                 


/*
echo "
var map = L.map('map',{
center:[ -22.931677, -48.521582 ],
zoom: 5,
layers:[saopaulo]
});\n";
*/

/*
echo "
var map = new L.Map('map', {center: new L.LatLng(-22.931677, -48.521582),
                zoom: 6,
                layers: [saopaulo]
          });\n";
          
*/                                            


/*

echo "var legend = L.control({position: 'bottomright'});\n";

 // cores amarelo -> vermelho
 echo "
 function getColor(d) {
 return   d > $passo7  ? '#99000d' :
          d > $passo6  ? '#cb181d' :
          d > $passo5  ? '#ef3b2c' :
          d > $passo4  ? '#fb6a4a' :
          d > $passo3  ? '#fc9272' :
          d > $passo2  ? '#ffaa8c' :
          d > $passo1  ? '#fee596' :
          d < 0        ? '#000000' :
          '#ffffff';
 }\n";


 echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),\n";
//  echo "grades = [0, $passo1,$passo2,$passo3,$passo4,$passo5,$passo6,$passo7 ],\n";
echo "grades=[0],
  labels = ['<strong>Teste </strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   if(from>0)
    fromx=from+0.1;
   else
    fromx=0;
   to = grades[i + 1];
                
   labels.push(
//   '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));
  '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + fromx.toFixed(1) + (to ? '&ndash;' + to : '+'));

  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";


   
//echo "
//   function onEachFeature(feature,layer) {
//    if (feature.properties && feature.properties.name) {
//     var popupContent='Cidade '+feature.properties.name+'<br>Density '+feature.properties.density
//    }
//    layer.bindPopup(popupContent);
//   } 
//\n";


/*
 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.density),
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'gray',        // contorno dos estados
   dashArray: '1',
   fillOpacity: 0.85
  };
  
 }\n";

echo "
function highlightFeature(e) {
 var layer = e.target;
 layer.setStyle({
 weight: 2,
 color: '#000000',
 dashArray: '3',
 fillOpacity: 0.7
 });
                                           
 if (!L.Browser.ie && !L.Browser.opera && !L.Browser.edge) {
  layer.bringToFront();
 }
 info.update(layer.feature.properties); 
}
                                                            

function resetHighlight(e) {
 geojson.resetStyle(e.target);
}


function zoomToFeature(e) {
 map.fitBounds(e.target.getBounds());
}
\n";

 echo "
 function onEachFeature(feature, layer) {
  layer.on({
  mouseover: highlightFeature,
  mouseout: resetHighlight
  });
  if (feature.properties && feature.properties.name) {
//   var posi=L.LatLng(feature.geometry);
   var popupContent='Cidade '+feature.properties.name+'<br>Density '+feature.properties.density;

  }
  layer.bindPopup(popupContent);
 }  
  
\n";


 echo "
 function Featurebenito(feature_benito, layer_benito) {
  if (feature_benito.properties && feature_benito.properties.name) {
   var popupContent=feature_benito.properties.name;
  }
  layer_benito.bindPopup(popupContent);
 }  
  
\n";

/*
 echo "                                
 geojson = L.geoJson(statesData, {
 style: style,
 onEachFeature: onEachFeature
}).addTo(map);\n
";
*/


//echo "geo_benito=L.geoJson(benito).addTo(map);\n";
/*
 echo "                                
 geo_benito = L.geoJson(benito, {
 style: {
   fillColor: 'blue',
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'gray',        // contorno dos estados
   fillOpacity: 0.85
  },onEachFeature: Featurebenito
}).addTo(map);\n";
*/

// echo "L.geoJson(statesData,{style:style,onEachFeature:onEachFeature})
//       .addTo(map);
// \n";

echo "L.control.scale(10,true,false,false).addTo(map);\n";

//echo "L.marker([-23.766312,-53.306268]).addTo(map);\n";


/*
echo "
var info = L.control();
info.onAdd = function (map) {
 this._div = L.DomUtil.create('div', 'info'); // cria  a div class 'info'
 this.update();
 return this._div;
};
";
 
*/            
/*
echo "
 info.update = function (props) {
 this._div.innerHTML = '<h5>INDICADOR</h5>' +  (props ?
 '<b>' + props.name + '</b><br />' + props.density : 'Escolha uma cidade');
 };info.addTo(map);
 ";
*/



echo "</script></div>";




//echo "<div id=dados style='position:absolute; left:93%;top:200px;'>";
//echo "<a href=fretes.php><button type=button class='btn btn-small'>Nova analise</button></a>"


?>
