<!– MapServer Template –>
<!DOCTYPE html>
<html>
<head>
 <meta charset="utf-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <link rel="stylesheet" href="js/leaflet.css" />
    <!-- TWITTER BOOTSTRAP CSS -->
    <link href="css/bootstrap.css" rel="stylesheet" type="text/css"/>

  <style>
   #map { width: 92%; height: 900px; border: 1px solid #ffff00; cursor: pointer; padding:1px;align-items:center;margin:3px; }
   ul>li { font-size: 10px; }

.info {
 padding: 4px 6px;
 font: 14px/16px Arial, Helvetica, sans-serif;
 background: #ffffff;
# background: rgba(255,255,250,0.8);
 box-shadow: 0 0 15px rgba(0,0,0,0.2);
 border-radius: 5px;
}
.info h4 {
 margin: 0 0 5px;
 color: #777;
}


.legend {
 text-align:left;
 line-height: 16px;
 color: #555;
}
.legend i {
 width: 18px;
 height: 18px;
 float: left;
 margin-right: 8px;
 opacity: 0.7;
}

</style>
</head>


<body>
<?
require("conecta.php");

$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
$horas= $today['hours'];
$minutos= $today['minutes'];
$xhos=$_SERVER['REMOTE_ADDR'];
$xdatakl=sprintf("%02d/%02d/%04d %02d:%02d",$mday,$month,$year,$horas,$minutos);


 $geoson='{"type":"FeatureCollection","features":['; 
 $result=pg_Exec($conn,"select gid from municipios where uf='SP'");
 $num=pg_numrows($result); 
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome from municipios where gid='$r[0]'");
   $rh=pg_fetch_row($rf,0);
   $rh[1]=trim($rh[1]);
   if(strlen($rh[1])==0) continue;
   $density=0;
   $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$density,$rh[0]);
  } 
  $geoson.="]}";



// layer estados
$geoestados='{"type":"FeatureCollection","features":['; 
/*
$result=pg_Exec($conn,"select gid from estados");
$num=pg_numrows($result);
for($t=0;$t<$num;$t++) {
 $r=pg_fetch_row($result,$t);
 $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome from estados where gid='$r[0]'");
 $rh=pg_fetch_row($rf,0);
 $rh[1]=trim($rh[1]);
 $geoestados.=sprintf('{"type":"Feature","properties":{"name":"%s"},"geometry":%s},',$rh[1],$rh[0]);
}
*/ 
$geoestados.="]}";


// layer benito
$geobenito='{"type":"FeatureCollection","features":['; 
$result=pg_Exec($conn,"select gid from costa");
$num=pg_numrows($result);
for($t=0;$t<$num;$t++) {
 $r=pg_fetch_row($result,$t);
 $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),id from costa where gid='$r[0]'");
 $rh=pg_fetch_row($rf,0);
 $rh[1]=trim($rh[1]);
 $geobenito.=sprintf('{"type":"Feature","properties":{"name":"%s"},"geometry":%s},',$rh[1],$rh[0]);
} 
$geobenito.="]}";




/*
  $distancia= ($maxvalor / 7);
  

  $passo1 = $minvalor ; 
  $passo2 = round($passo1 + $distancia,1);
  $passo3 = round($passo2 + $distancia,1);
  $passo4 = round($passo3 + $distancia,1);
  $passo5 = round($passo4 + $distancia,1);
  $passo6 = round($passo5 + $distancia,1);
  $passo7 = round($passo6 + $distancia,1);
*/  
//  $passo8 = $passo7 + $distancia;
//  $passo9 = $passo8 + $distancia;
//  $passo10= $passo9 + $distancia;


echo "
 <div id=map></div>\n";

echo " <script src=js/leaflet.js></script>\n";
 
//echo " <script src=https://unpkg.com/leaflet@1.0.3/dist/leaflet.js></script>\n";
echo "
 <script src=js/jquery-2.1.1.min.js></script>\n
 <script src=js/bundle.js></script>\n

 <script>\n
   var statesData=$geoson;\n
   var estados=$geoestados;\n
   var benito=$geobenito;\n
";

echo "var map = L.map('map').setView([-22.06019, -48.70239], 5);\n";

echo "
function style(feature) {
 return {
 fillColor: '#ffffff',
 weight: 1,
 opacity: 0.5,
 transparency: 1,
 color: 'blue',        // contorno dos municipios
 dashArray: '1',  
 fillOpacity: 0.6
 };
}\n";
                              
echo "
function highlightFeature(e) {
 var layer = e.target;
 layer.setStyle({
  weight: 2,
  color: '#000000',
  dashArray: '1', 
  fillOpacity: 0.7
 });
                                                      
 if (!L.Browser.ie && !L.Browser.opera && !L.Browser.edge) {
  layer.bringToFront();
 }
 info.update(layer.feature.properties); 
}
                                                                                                                       
                                                                                                                       
function resetHighlight(e) {  
 geojson.resetStyle(e.target);
}
                                                                                                                        
                                                                                                             
function zoomToFeature(e) {
  map.fitBounds(e.target.getBounds());
}   
\n";
                                                                                                            
 echo "
 function onEachFeature(feature, layer) {
  layer.on({
  mouseover: highlightFeature,
  mouseout: resetHighlight
  });
  if (feature.properties && feature.properties.name && feature.properties.density>=0) {
   var popupContent='Cidade '+feature.properties.name+'<br>Frete R$/t '+feature.properties.density;;

  }
  layer.bindPopup(popupContent);
 }  
\n";




/*
 echo "geoesta=L.geoJson(estados,{style: {
                                   weight: 2,
                                   color: 'black',
                                   dashArray:1,
                                   opacity: 1,
                                   fillColor: 'white',
                                   fillOpacity: 0
                                  }
 
 }).addTo(map);
 \n";
*/
echo "                                
geojson = L.geoJson(statesData, {
 style:style, onEachFeature : onEachFeature
}).addTo(map);\n
";


/*
echo "
var geojsonMarkerOptions = {
  radius: 8,
  fillColor: '#ff7800',
  color: '#000',
  weight: 1,
  opacity: 1,
  fillOpacity: 0.8
};\n
                        
 L.geoJson(benito, {
 pointToLayer: function (feature, latlng) {
  return L.circleMarker(latlng, geojsonMarkerOptions);
 }
}).addTo(map);\n";
*/

echo "                                
 geobenito = L.geoJson(benito, {
 style: {
  weigth:2,
  color:'blue',
  opacity:1,
  fillCollor:'red',
  fillOpacity:0
  }
}).addTo(map);\n
";



echo "L.control.scale(10,true,false,false).addTo(map);\n";

//  for($t=0;$t<count($vetor_pontos);$t++) {
//  echo "L.marker([ $vetor_pontos[$t] ]).addTo(map);\n";
//}
//echo "L.marker([-15.180128, -56.331404]).addTo(map);\n";

//echo "var legend = L.control({position: 'bottomright'});\n";


echo "
var info = L.control();

info.onAdd = function (map) {
 this._div = L.DomUtil.create('div', 'info'); // cria  a div class 'info'
 this.update();
 return this._div;
};\n";
            
 echo "
 info.update = function (props) {
 this._div.innerHTML =  (props ? '<b>' + props.name + '</b>'  : 'Escolha uma cidade');
 };info.addTo(map);
 \n";

echo "</script></div>";




//echo "<div id=dados style='position:absolute; left:93%;top:200px;'>";
//echo "<a href=fretes.php><button type=button class='btn btn-small'>Nova analise</button></a>"


