<!– MapServer Template –>
<!DOCTYPE html>
<html>
<head>
 <meta charset="utf-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <link rel="stylesheet" href="css/leaflet.css" />
    <!-- TWITTER BOOTSTRAP CSS -->
    <link href="css/bootstrap.css" rel="stylesheet" type="text/css"/>

  <style>
   #map { width: 92%; height: 800px; border: 1px solid #ffff00; cursor: pointer; }
   ul>li { font-size: 10px; }

.info {
 padding: 4px 6px;
 font: 14px/16px Arial, Helvetica, sans-serif;
 background: #ffffff;
# background: rgba(255,255,250,0.8);
 box-shadow: 0 0 15px rgba(0,0,0,0.2);
 border-radius: 5px;
}
.info h4 {
 margin: 0 0 5px;
 color: #777;
}


.legend {
 text-align:left;
 line-height: 16px;
 color: #555;
}
.legend i {
 width: 18px;
 height: 18px;
 float: left;
 margin-right: 8px;
 opacity: 0.7;
}

</style>
</head>


<body>
<?
require("conecta.php");

$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
$horas= $today['hours'];
$minutos= $today['minutes'];
$xhos=$_SERVER['REMOTE_ADDR'];
$xdatakl=sprintf("%02d/%02d/%04d %02d:%02d",$mday,$month,$year,$horas,$minutos);
/*
// cria a linha de log
// tipo :
if($xanalise==1) $xanal="Indicadores de fretes";
if($xanalise==2) $xanal="Diferencial de porto";
if($xanalise==3) $xanal="Paridade Preços Produto x Frete";
if($xanalise==4) $xanal="SIG-Log";

if($xprod==1) $xprodu="ACUCAR";
if($xprod==2) $xprodu="MILHO";
if($xprod==3) $xprodu="SOJA";
if($xprod==4) $xprodu="FERTILIZANTES";
if($xprod==5) $xprodu="ARROZ";
if($xprod==6) $xprodu="ETANOL";

if($xporto==0) $xport="PARANAGUA";
if($xporto==1) $xport="SANTOS";
if($xporto==2) $xport="S.Francisco Sul";
if($xporto==3) $xport="Sao Luis";
if($xporto==4) $xport="Rio Grande";
if($xporto==5) $xport="Salvador";

$PRECONOPORTO=$xprecoport;

$periodo=sprintf("%02d/%04d",$mes,$ano);

$xlog=sprintf("%s %s | %s | %s | %s | %7.2f | %s",$xhos,$xdatakl,$xanal,$xprodu,$xport,$PRECONOPORTO,$periodo);

$result=pg_Exec($conn,"select log,registro from usuarios where email='$user'");
$RM=pg_fetch_row($result,0);
$RM[0]=trim($RM[0]).sprintf("\n%s",$xlog);
$result=pg_Exec($conn,"update usuarios set log='$RM[0]' where registro='$RM[1]'");
*/

$volta=(int)$volta;
$geoson="{}";
if($volta==1) {

 /*
  1 = acucar
  2 = milho
  3 = soja
 */

 $geoson='{"type":"FeatureCollection","features":['; 

// echo "<br>xtpma=$xtpma<br>xprod=$xprod";

  $result=pg_Exec($conn,"select nome from municipio_sp");
 
  $num=pg_numrows($result);
  $minvalor=999999;$maxvalor=0;
 
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome,populacao from municipio_sp where nome='$r[0]'");
   $rh=pg_fetch_row($rf,0);
   $rh[2]=(int)$rh[2];
   $rh[1]=trim($rh[1]);
  
   $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$rh[2],$rh[0]);
  } 
  $geoson.="]}";

}



 function selporto($x) {
  if($x==0) return ("Paranaguá");
  if($x==1) return("Santos");
  if($x==2) return("São Francisco do Sul");
  if($x==3) return("São Luís");
  if($x==4) return("Rio Grande");
  if($x==5) return("Salvador");
 }

if($xtpma==4)$geoson='{}';

echo "
 <div id=map></div>\n";

echo " <script src=js/leaflet.js></script>\n";
 
//echo " <script src=https://unpkg.com/leaflet@1.0.3/dist/leaflet.js></script>\n";
echo "
 <script src=js/jquery-2.1.1.min.js></script>\n
 <script src=js/bundle.js></script>\n

 <script>\n
   var statesData=$geoson;\n
";
?>
var map = L.map('map').setView([-9.5675, -48.0013], 5);

 var results=new L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {}).addTo(map);
<!--  var results = L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}.png', { -->
<!--			maxZoom: 18,    -->
<!--			attribution: 'Map data © <a href="http://openstreetmap.org">OpenStreetMap</a> contributors', -->
<!-- 		}).addTo(map);  -->

<?
echo "var host = 'http://192.168.4.12/cgi/rocha/mapserv.fcgi?'";
//echo "var host = 'http://179.234.170.113:6080/sergio/esalqlog/mapserv.fcgi?'";
?>

   var mapfile = "map=inter.map";
   var wms_server = host + mapfile;

   var municipios = L.tileLayer.wms(wms_server, {
      layers: 'municipios',
      format: 'image/png',
      srs:"EPSG:4291",
      opacity: 10,
      transparency : 10,
      pointerCursor: true,
      status:true
   }).addTo(map);

//   var armazens = new L.tileLayer.wms(wms_server, {
//      layers: 'armazens',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);

//   var mesoregioes = new L.tileLayer.wms(wms_server, {
//      layers: 'mesoregioes',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);
   
//   var microregioes = new L.tileLayer.wms(wms_server, {
//      layers: 'microregioes',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);
   
//   var rodovias = new L.tileLayer.wms(wms_server, {
//      layers: 'rodovias',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
 //     status:false
//   }).addTo(map);

//   var usinas = new L.tileLayer.wms(wms_server, {
//      layers: 'usinas',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);

//   var terminal_ferroviario = new L.tileLayer.wms(wms_server, {
//      layers: 'terminal_ferroviario',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);

//   var industria_oleo = new L.tileLayer.wms(wms_server, {
//      layers: 'industria_oleo',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);


//   var ferrovias = new L.tileLayer.wms(wms_server, {
//      layers: 'ferrovias',
//      format: 'image/png',
//      srs:"EPSG:4291",
//      transparent: true,
//      pointerCursor: true,
//      status:false
//   }).addTo(map);


   
   var baseMaps={};
   var overlayMaps={"Mesoregioes":mesoregioes,
                    "Armazens":armazens,
                    "Rodovias Brasil":rodovias,
                    "Ferrovias Brasil":ferrovias,
                    "Usinas acucar e etanol":usinas,
                    "Terminais Ferroviarios":terminal_ferroviario,
                    "Industria de Oleo":industria_oleo                    
                   };
                   
   L.control.layers(baseMaps,overlayMaps).addTo(map);   
   L.control.scale(10,true,false,false).addTo(map);   

//map.removeLayer(municipios);

//map.removeLayer(mesoregioes);
//map.removeLayer(armazens);
//map.removeLayer(microregioes);
//map.removeLayer(rodovias);
//map.removeLayer(ferrovias);
//map.removeLayer(usinas);
//map.removeLayer(terminal_ferroviario);
//map.removeLayer(industria_oleo);

var checks = document.querySelectorAll('[type = "checkbox"]'), i;
function disCheck() {
    for (i = 0; i < checks.length; ++i) 
            checks[i].checked = false;
}
disCheck();
   var popup=L.popup();
   function Identify(e) {
      popup
      .setLatLng(e.latlng)
      .setContent("Cidade<br>Coord "+e.latlng.toString())
      .openOn(map);
   } 
    map.on('click',Identify);


<?

//echo "
//var printer = L.easyPrint({
// sizeModes: ['Current', 'A4Landscape', 'A4Portrait'],
// filename: 'Mapa',
// exportOnly: true,
// position: 'topleft'
//}).addTo(map);\n";

if($xtpma==1) {                 // *** diferencial de porto //
 if($xprod==2 or $xprod==3) {
  $passo=0; 
  $passo2=50;
  $passo3=100;
  $passo4=150;
  $passo5=200;
  $passo6=250;
  $passo7=300;
  $passo8=350;
  $passo9=400;
 } elseif($xprod==1) {
  $passo=0; 
  $passo2=60;
  $passo3=80;
  $passo4=100;
  $passo5=120;
  $passo6=140;
  $passo7=160;
  $passo8=200;
  $passo9=240;
 }
 if($xprod==2) {  // milho 
 echo "
 function getColor(d) {
   return d>  $passo9  ? '#00441b':
          d > $passo8  ? '#006d2c' :
          d > $passo7  ? '#238b45' :
          d > $passo6  ? '#41ab5d' :
          d > $passo5  ? '#74c476' :
          d > $passo4  ? '#a1d99b' :
          d > $passo3  ? '#c7e9c0' :
          d > $passo2  ? '#e5f5e0' :
          d > $passo   ? '#f7fcf5' :
          '#ffed6f';
 }\n";
 }
 if($xprod==3) {  // soja
  echo "
  function getColor(d) {
    return d>  $passo9  ? '#7f0000':
           d > $passo8  ? '#b30000' :
           d > $passo7  ? '#d7301f' :
           d > $passo6  ? '#ef6548' :
           d > $passo5  ? '#fc8d59' :
           d > $passo4  ? '#fdbb84' :
           d > $passo3  ? '#fdd49e' :
           d > $passo2  ? '#fee8c8' :
          d > $passo   ? '#fff7ec' :
          '#ffed6f';
 }\n";
 }
 if($xprod==1) {     // acucar
  echo "
  function getColor(d) {
   return d>  $passo9  ? '#08306b':
          d > $passo8  ? '#08519c' :
          d > $passo7  ? '#2171b5' :
          d > $passo6  ? '#4292c6' :
          d > $passo5  ? '#6baed6' :
          d > $passo4  ? '#9ecae1' :
          d > $passo3  ? '#c6dbef' :
          d > $passo2  ? '#deebf7' :
          d > $passo   ? '#f7fbff' :
          '#ffed6f';
 }\n";
 }
 
 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.density),
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'white',        // contorno dos estados
   dashArray: '1',
   fillOpacity: 0.85
  };
  
 }\n";

 echo "

function onEachFeature(feature, layer) {
 if (feature.properties && feature.properties.name) {
  layer.bindPopup('<p>Meso :'+feature.properties.name+'<br>Porto:'+feature.properties.porto+'<br>R$/t :'+feature.properties.density+'<br>'+feature.properties.tabela+'</p>');
 }
}                
\n";

 echo "L.geoJson(statesData,{style:style,onEachFeature:onEachFeature})
       .addTo(map);
 \n";

} 

if($xtpma==3) {             //paridades
 $passo2=$passo*2;
 $passo3=$passo*3;
 $passo4=$passo*4;
 $passo5=$passo*5;
 $passo6=$passo*6;
// $passo7=$passo*7;
// $passo8=$passo*8;
// $passo9=$passo*9;
// $passo10=$passo*10;
// $passo11=$passo*11;
// $passo12=$passo*12;

 echo "
 function getColor(d) {
   return d > $passo5  ? '#006837' :
          d > $passo4  ? '#31a354' :
          d > $passo3  ? '#78c679' :
          d > $passo2  ? '#addd9e' :
          d > $passo  ? '#d9f0a3' :
          '#ffffcc';
}\n";

// 11 -> 0 #ff0000, #e71700, #d02e00, #b94500, #a25c00, #8b7300, #738b00, #5ca200, #45b900, #2ed000, #17e700, #00ff00
// 11 -> 0 #bf2a00, #ad3b00, #9c4c01, #8a5d01, #796e02, #687f03, #569003, #45a104, #34b205, #22c305, #11d406, #00e507 
 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.density),
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'white',        // contorno dos estados
   dashArray: '1',
   fillOpacity: 0.4
   
  };
 }\n";

 echo "L.geoJson(statesData, {style: style}).addTo(map);";

} 
if($xtpma==2) {            ///////////////  mapa de diferencas ////////////////////

 echo "
 function getColor(d) {
   return  d=='Paranaguá'            ? '#3288bd':    // azul
          d =='Santos'               ? '#99d594' :   // pink
          d =='São Luís'             ? '#fc8d59' :   // marrom
          d =='São Francisco do Sul' ? '#e6f598' :   // verde
          d =='Rio Grande'           ? '#d53e4f' :   // chocolate
          d =='Salvador'             ? '#999999' :   // amarelo
          '#ffffff';
 }\n";


 
 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.porto),
   weight: 1,
   opacity: 1.0,
   transparency: 1,
   color: 'white',        // contorno dos estados
   dashArray: '1',
   fillOpacity: 0.85
  };
  
 }\n";

 echo "

function onEachFeature(feature, layer) {
 if (feature.properties && feature.properties.name) {
  layer.bindPopup('<p>Meso :'+feature.properties.name+'<br>Porto:'+feature.properties.porto+'<br>R$/t :'+feature.properties.density+'<br>'+feature.properties.tabela+'</p>');
 }
}                
\n";

 echo "L.geoJson(statesData,{style:style,onEachFeature:onEachFeature})
      .addTo(map);
 \n";
}

?>
                                                        
function highlightFeature(e) {
 var layer = e.target;
    
 layer.setStyle({
 weight: 2,
 color: '#ff4500',
 dashArray: '1',
 fillOpacity: 0.7
 });
                                           
 if (!L.Browser.ie && !L.Browser.opera && !L.Browser.edge) {
  layer.bringToFront();
 }
 info.update(layer.feature.properties); 
}
                                                            

function resetHighlight(e) {
 geojson.resetStyle(e.target);
}


function zoomToFeature(e) {
 map.fitBounds(e.target.getBounds());
}

<?
if($xtpma==1 or $xtpma==3)  {
 echo "
 function onEachFeature(feature, layer) {
  layer.on({
  mouseover: highlightFeature,
  mouseout: resetHighlight
  });
 }
";
 echo "                                
 geojson = L.geoJson(statesData, {
 style: style,
 onEachFeature: onEachFeature
}).addTo(map);
";
}
?>


var legend = L.control({position: 'bottomright'});

<? 
if($xtpma==1 ) {
 echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),
  grades = [0, $passo2,$passo3,$passo4,$passo5,$passo6,$passo7,$passo8,$passo9 ],
  labels = ['<strong>Preços de Frete (R$/t) </strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   to = grades[i + 1];
                
   labels.push(
//   '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));
  '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));

  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";


} elseif($xtpma==2) {         /// DIFERENCAS

echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),
  grades = ['Paranaguá','Santos','São Luís','São Francisco do Sul','Rio Grande','Salvador'],
  labels = ['<strong>Porto de Exportação </strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   to = grades[i + 1];
                
   labels.push(
   '<br><i style=\"background:' + getColor(from ) + '\"></i> ' + from );
  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";

} elseif($xtpma==3 ) {
 echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),
  grades = [0, $passo,$passo2,$passo3,$passo4,$passo5],
  labels = ['<strong>Paridade de Precos (%) </strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   to = grades[i + 1];
                
   labels.push(
//   '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));
  '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));

  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";

}

?>

<?
if($xtpma==1 or $xtpma==3) {
echo "
var info = L.control();

info.onAdd = function (map) {
 this._div = L.DomUtil.create('div', 'info'); // cria  a div class 'info'
 this.update();
 return this._div;
};
";
            
 // method that we will use to update the control based on feature properties passed
 if($xtpma==1) {
 $npro="";
 if($xprod==1) $npro="ACUCAR";
 if($xprod==2) $npro="MILHO";
 if($xprod==3) $npro="SOJA";
 echo "
 info.update = function (props) {
 this._div.innerHTML = '<h5>INDICADOR MÉDIO PREÇO FRETE $npro (R$/t)</h5>' +  (props ?
 '<b>' + props.name + '</b><br />' + props.density : 'Escolha uma cidade');
 };info.addTo(map);
 ";
 }
 if($xtpma==3) {
 echo "
 info.update = function (props) {
 this._div.innerHTML = '<h5>Paridade de Preços entre Frete e Produto (%)</h5>' +  (props ?
 '<b>' + props.name + '</b><br>'+props.tabela : 'Escolha uma cidade');
 };info.addTo(map);
 "; 
 }
}

if($xtpma==4) {
 if($xarmazens=='X') echo "map.addLayer(armazens);layer.bringToFront();\n";
 else echo "map.removeLayer(armazens);\n";
 if($xusinas=='X') {
  echo "map.addLayer(usinas);layer.bringToFront();\n";
 }else
  echo "map.removeLayer(usinas);\n";
 if($xterminais=='X') echo "map.addLayer(terminal_ferroviario);layer.bringToFront();\n";
 else echo "map.removeLayer(terminal_ferroviario);\n";
 if($xoleo=='X') echo "map.addLayer(industria_oleo);layer.bringToFront();\n";
 else echo "map.removeLayer(industria_oleo);\n";
 if($xrodovias=='X') echo "map.addLayer(rodovias);layer.bringToFront();\n";
 else echo "map.removeLayer(rodovias);\n";
 if($xferrovias=='X') echo "map.addLayer(ferrovias);layer.bringToFront();\n";
 else echo "map.removeLayer(ferrovias);\n";


}

//echo "
//var printer = L.easyPrint({
// sizeModes: ['Current', 'A4Landscape', 'A4Portrait'],
// filename: 'Mapa',
// exportOnly: true,
// position: 'topleft'
//}).addTo(map);\n";

                                                      
//echo "                                                      
// function manualPrint () {
// printer.printMap('CurrentSize', 'MyManualPrint')
//}\n";

echo "</script>";


echo "<div id=dados style='position:absolute; left:93%;top:200px;'>";
echo "<a href=fretes.php><button type=button class='btn btn-small'>Nova analise</button></a>"


?>
