<!– MapServer Template –>
<!DOCTYPE html>
<html>
<head>
 <meta charset="utf-8" />
 <meta name="viewport" content="width=device-width, initial-scale=1.0">
 <link rel="stylesheet" href="js/leaflet.css" />
    <!-- TWITTER BOOTSTRAP CSS -->
    <link href="css/bootstrap.css" rel="stylesheet" type="text/css"/>

  <style>
   #map { width: 92%; height: 900px; border: 1px solid #ffff00; cursor: pointer; padding:1px;align-items:center;margin:3px; }
   ul>li { font-size: 10px; }

.info {
 padding: 4px 6px;
 font: 14px/16px Arial, Helvetica, sans-serif;
 background: #ffffff;
# background: rgba(255,255,250,0.8);
 box-shadow: 0 0 15px rgba(0,0,0,0.2);
 border-radius: 5px;
}
.info h4 {
 margin: 0 0 5px;
 color: #777;
}


.legend {
 text-align:left;
 line-height: 16px;
 color: #555;
}
.legend i {
 width: 18px;
 height: 18px;
 float: left;
 margin-right: 8px;
 opacity: 0.7;
}

</style>
</head>


<body>
<?
require("conecta.php");

$today = getdate();
$month = $today['mon']; 
$mday = $today['mday']; 
$year = $today['year'];
$horas= $today['hours'];
$minutos= $today['minutes'];
$xhos=$_SERVER['REMOTE_ADDR'];
$xdatakl=sprintf("%02d/%02d/%04d %02d:%02d",$mday,$month,$year,$horas,$minutos);


 $geoson='{"type":"FeatureCollection","features":['; 


//$produto="Fertilizantes";
//$mun_origem="Cubatão (SP)";
//$mes=9;
//$ano=18;

if($mes ==  1) $r="jan";
if($mes ==  2) $r="fev";
if($mes ==  3) $r="mar";
if($mes ==  4) $r="abr";
if($mes ==  5) $r="mai";
if($mes ==  6) $r="jun";
if($mes ==  7) $r="jul";
if($mes ==  8) $r="ago";
if($mes ==  9) $r="set";
if($mes == 10) $r="out";
if($mes == 11) $r="nov";
if($mes == 12) $r="dez";

$campo=sprintf("frete_%s%s",$r,$ano);

// shape geral
 $xcond=" (";
 $resultg=pg_Exec($conn,"select destino from dados_gabao where origem='$mun_origem' and produto='$produto'");
 $numg=pg_numrows($resultg);
 for($t=0;$t<$numg;$t++) {
  $rt=pg_fetch_row($resultg,$t);
  $rt[0]=trim($rt[0]);
  if($t>0) $xcond.=" and ";
  $xcond.=" nome<>'$rt[0]' ";
 }
 $xcond.=")";
// echo "<br>$xcond<br>";

 $result=pg_Exec($conn,"select gid from municipios where $xcond");
 $num=pg_numrows($result); 
  for($t=0;$t<$num;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome from municipios where gid='$r[0]'");
   $rh=pg_fetch_row($rf,0);
   $rh[1]=trim($rh[1]);
   if(strlen($rh[1])==0) continue;
   if($rh[1]=="$mun_origem") $density=-1; else $density=0;
   $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$density,$rh[0]);
  } 
//  $geoson.="]}";


// shape com valores
$xcond=" (";
 for($t=0;$t<$numg;$t++) {
  $rt=pg_fetch_row($resultg,$t);
  $rt[0]=trim($rt[0]);
  if($t>0) $xcond.=" or ";
  $xcond.=" nome='$rt[0]' ";
 }
 $xcond.=")";
// echo "<br>$xcond<br>";


 $indice=0;
 $result=pg_Exec($conn,"select gid from municipios where $xcond");
 $numvalores=pg_numrows($result);
 $minvalor=999999;$maxvalor=0;
  for($t=0;$t<$numvalores;$t++) {
   $r=pg_fetch_row($result,$t);
   $rf_valores=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome,st_y(st_centroid(geom)),st_x(st_centroid(geom)) 
                      from municipios where gid='$r[0]'");
   $rh=pg_fetch_row($rf_valores,0);
   $rh[1]=trim($rh[1]);
   if(strlen($rh[1])==0) continue;
   $vetor_pontos[$indice++]=sprintf("%f , %f",$rh[2],$rh[3]);
   $strc=sprintf("select %s from dados_gabao where destino='%s' and produto='%s' and origem='%s'",$campo,$rh[1],$produto,$mun_origem);
//    echo "<br>$strc<br>";
    $result_x=pg_Exec($conn,$strc);
    $num_x=pg_numrows($result_x);
    for($g=0;$g<$num_x;$g++) {
     $rt=pg_fetch_row($result_x,$g);
     $rt[0]=(float) str_replace(",",".",$rt[0]);
     $geoson.=sprintf('{"type":"Feature","properties":{"name":"%s","density":"%5.2f"},"geometry":%s},',$rh[1],$rt[0],$rh[0]);
     if($rt[0]>$maxvalor) $maxvalor=$rt[0];
     if($rt[0]<$minvalor) $minvalor=$rt[0];
    }
  } 
  $geoson.="]}";

//echo "<br>$minvalor - $maxvalor";


// layer estados
$geoestados='{"type":"FeatureCollection","features":['; 
$result=pg_Exec($conn,"select gid from estados");
$num=pg_numrows($result);
for($t=0;$t<$num;$t++) {
 $r=pg_fetch_row($result,$t);
 $rf=pg_Exec($conn,"select ST_AsGeoJSON(geom),nome from estados where gid='$r[0]'");
 $rh=pg_fetch_row($rf,0);
 $rh[1]=trim($rh[1]);
 $geoestados.=sprintf('{"type":"Feature","properties":{"name":"%s"},"geometry":%s},',$rh[1],$rh[0]);
} 
$geoestados.="]}";


  $distancia= ($maxvalor / 7);
  

  $passo1 = $minvalor ; 
  $passo2 = round($passo1 + $distancia,1);
  $passo3 = round($passo2 + $distancia,1);
  $passo4 = round($passo3 + $distancia,1);
  $passo5 = round($passo4 + $distancia,1);
  $passo6 = round($passo5 + $distancia,1);
  $passo7 = round($passo6 + $distancia,1);
//  $passo8 = $passo7 + $distancia;
//  $passo9 = $passo8 + $distancia;
//  $passo10= $passo9 + $distancia;


echo "
 <div id=map></div>\n";

echo " <script src=js/leaflet.js></script>\n";
 
//echo " <script src=https://unpkg.com/leaflet@1.0.3/dist/leaflet.js></script>\n";
echo "
 <script src=js/jquery-2.1.1.min.js></script>\n
 <script src=js/bundle.js></script>\n

 <script>\n
   var statesData=$geoson;\n
   var estados=$geoestados;\n
";

echo "var map = L.map('map').setView([-22.06019, -48.70239], 4);\n";

/*
echo "var results=new L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {}).addTo(map);\n";

echo "var results = L.tileLayer('http://server.arcgisonline.com/ArcGIS/rest/services/World_Street_Map/MapServer/tile/{z}/{y}/{x}.png', {\n
		maxZoom: 18, \n
		attribution: 'Map data © <a href="http://openstreetmap.org">OpenStreetMap</a> contributors',\n
 		}).addTo(map);\n";

*/

//echo "var host = 'http://127.0.0.1/cgi/sandbox/gabao/mapserv.fcgi?'";
//echo "var host = 'http://179.234.170.113:6080/sergio/esalqlog/mapserv.fcgi?'";
/*
echo "
\n
   var mapfile = 'map=inter.map';
   var wms_server = host + mapfile;
";
*/
/*
echo "\n
   var municipios = L.tileLayer.wms(wms_server, {
      layers: 'municipios',
      format: 'image/png',
      srs:'EPSG:4291',
      opacity: 1,
      transparency : 1,
      pointerCursor: true,
      status:true
   }).addTo(map);\n";
*/
/*
echo "
      var estados = L.tileLayer.wms(wms_server, {
      layers: 'estados',
      format: 'image/png',
      srs:'EPSG:4291',
      opacity: 1,
      transparency : 1,
      pointerCursor: true,
      status:true
   }).addTo(map);\n";
*/
   
//echo "
//   function onEachFeature(feature,layer) {
//    if (feature.properties && feature.properties.name) {
//     var popupContent='Cidade '+feature.properties.name+'<br>Density '+feature.properties.density
//    }
//    layer.bindPopup(popupContent);
//   } 
//\n";

 echo "
 function style(feature) {
  return {
   fillColor: getColor(feature.properties.density),
   weight: 1,
   opacity: 0.5,
   transparency: 1,
   color: 'gray',        // contorno dos municipios
   dashArray: '1',
   fillOpacity: 0.6
  };
  
 }\n";


 // cores amarelo -> vermelho
 echo "
 function getColor(d) {
 return   d > $passo7  ? '#99000d' :
          d > $passo6  ? '#cb181d' :
          d > $passo5  ? '#ef3b2c' :
          d > $passo4  ? '#fb6a4a' :
          d > $passo3  ? '#fc9272' :
          d > $passo2  ? '#ffaa8c' :
          d > $passo1  ? '#fee596' :
          d < 0        ? '#000000' :
          '#ffffff';
 }\n";


echo "
function highlightFeature(e) {
 var layer = e.target;
    
 layer.setStyle({
 weight: 2,
 color: '#000000',
 dashArray: '1',
 fillOpacity: 0.7
 });
                                           
 if (!L.Browser.ie && !L.Browser.opera && !L.Browser.edge) {
  layer.bringToFront();
 }
 info.update(layer.feature.properties); 
}
                                                            

function resetHighlight(e) {
 geojson.resetStyle(e.target);
}


function zoomToFeature(e) {
 map.fitBounds(e.target.getBounds());
}
\n";

 echo "
 function onEachFeature(feature, layer) {
  layer.on({
  mouseover: highlightFeature,
  mouseout: resetHighlight
  });
  if (feature.properties && feature.properties.name && feature.properties.density>=0) {
   var popupContent='Cidade '+feature.properties.name+'<br>Frete R$/t '+feature.properties.density;;

  }
  layer.bindPopup(popupContent);
 }  
  
\n";

 echo "geoesta=L.geoJson(estados,{style: {
                                   weight: 2,
                                   color: 'black',
                                   dashArray:1,
                                   opacity: 1,
                                   fillColor: 'white',
                                   fillOpacity: 0
                                  }
 
 }).addTo(map);
 \n";

echo "                                
 geojson = L.geoJson(statesData, {
 style: style,
 onEachFeature: onEachFeature
}).addTo(map);\n
";



echo "L.control.scale(10,true,false,false).addTo(map);\n";

  for($t=0;$t<count($vetor_pontos);$t++) {
  echo "L.marker([ $vetor_pontos[$t] ]).addTo(map);\n";
}
//echo "L.marker([-15.180128, -56.331404]).addTo(map);\n";

echo "var legend = L.control({position: 'bottomright'});\n";

 echo "
 legend.onAdd = function (map) {
  var div = L.DomUtil.create('div', 'info legend'),
  grades = [0,$passo1,$passo2,$passo3,$passo4,$passo5,$passo6,$passo7 ],
  labels = ['<strong>Frete (R$/t)</strong>'],
  from, to;
            
  for (var i = 0; i < grades.length; i++) {
   from = grades[i];
   if(from>0)
    fromx=from+0.1;
   else
    fromx=0;
   to = grades[i + 1];
                
   labels.push(
//   '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + from + (to ? '&ndash;' + to : '+'));
  '<br><i style=\"background:' + getColor(from + 1) + '\"></i> ' + fromx.toFixed(1) + (to ? '&ndash;' + to : '+'));

  }
                                 
  div.innerHTML = labels.join('<br>');
  return div;
 };legend.addTo(map);";


echo "
var info = L.control();

info.onAdd = function (map) {
 this._div = L.DomUtil.create('div', 'info'); // cria  a div class 'info'
 this.update();
 return this._div;
};\n";
            
 echo "
 info.update = function (props) {
 this._div.innerHTML = '<h5>DE $mun_origem</h5>' +  (props ?
 '<b>' + props.name + '</b><br />R$/t ' + (props.density>0? props.density:0.00)  : 'Escolha uma cidade');
 };info.addTo(map);
 \n";

echo "</script></div>";




//echo "<div id=dados style='position:absolute; left:93%;top:200px;'>";
//echo "<a href=fretes.php><button type=button class='btn btn-small'>Nova analise</button></a>"



echo "<div id=logo style='position:absolute;top:2%;left:4%;width:85%;z-index:3;'>";
echo "<table border=0 width=40%>";
echo "<tr><td valign=top align=center><img src=yara.png border=0 width=92%></td>";
echo "<td valign=top align=center><img src=Esalq_log_logo.png border=0 width=30%></td></tr>";
echo "</table></div>";
